/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.tools.data;

import java.io.IOException;
import java.io.InputStream;
import java.util.Random;

public class TexInputStream
extends InputStream {
    private static final boolean DEBUG = false;
    private static final boolean DECODE = true;
    private final InputStream in;
    private final Random rng;
    private long seed;
    private int accu;

    TexInputStream(InputStream inputStream, boolean bl) throws IOException {
        this.rng = this.initialiseRandomizer(inputStream, bl);
        this.in = inputStream;
        this.resetSeed();
    }

    public int read() throws IOException {
        return this.in.read() ^ 0xFF & (this.rng.nextInt() ^ --this.accu);
    }

    void resetSeed() {
        this.rng.setSeed(this.seed);
        this.accu = this.rng.nextInt();
    }

    private Random initialiseRandomizer(InputStream inputStream, boolean bl) throws IOException {
        long l = 0L;
        int n = bl ? 6 : 4;
        while (n-- > 0) {
            l = l << 8 | (long)inputStream.read();
        }
        this.seed = l = (bl ? 0xFFFFFFFFFFFFL : 0xFFFFFFFFL) & -l;
        return new Random(l);
    }
}

